index
DROP INDEX VBR.VHBP_DOCRCP_FK;

CREATE INDEX VBR.VHBP_DOCRCP_FK ON VBR.VET_HEALTH_BENEFIT_PLAN
(DOCUMENT_RECEIPT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.VETIDTYP_PK;

CREATE UNIQUE INDEX VBR.VETIDTYP_PK ON VBR.VETERAN_IDENTIFIER_TYPE
(VETERAN_IDENTIFIER_TYPE_ID)
LOGGING
TABLESPACE S_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOC_PK;

CREATE UNIQUE INDEX VBR.DOC_PK ON VBR.DOCUMENT
(DOCUMENT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOC_FLE_FK;

CREATE INDEX VBR.DOC_FLE_FK ON VBR.DOCUMENT
(FILE_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOC_DOCTYP_FK;

CREATE INDEX VBR.DOC_DOCTYP_FK ON VBR.DOCUMENT
(DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOC_DOCRCP_FK;

CREATE INDEX VBR.DOC_DOCRCP_FK ON VBR.DOCUMENT
(DOCUMENT_RECEIPT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOCTYP_PK;

CREATE UNIQUE INDEX VBR.DOCTYP_PK ON VBR.DOCUMENT_TYPE
(DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOCRCP_VET_NU_I;

CREATE INDEX VBR.DOCRCP_VET_NU_I ON VBR.DOCUMENT_RECEIPT
(VETERAN_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOCRCP_VETIDTYP_FK;

CREATE INDEX VBR.DOCRCP_VETIDTYP_FK ON VBR.DOCUMENT_RECEIPT
(VETERAN_IDENTIFIER_TYPE_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
DROP INDEX VBR.DOCRCP_PK;

CREATE UNIQUE INDEX VBR.DOCRCP_PK ON VBR.DOCUMENT_RECEIPT
(DOCUMENT_RECEIPT_ID)
LOGGING
TABLESPACE L_VBR_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;
